﻿using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using System.Collections.Generic;
using System.Linq;
using System;
using System.Diagnostics;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class MilitaryOccupationImporter : MilitaryInfoServiceClient
    { 
       
       public List<MilitaryOccupation> GetMilitaryOccupationData(string edipi)
        {
            if (string.IsNullOrEmpty(edipi)) throw new ArgumentNullException(nameof(edipi));

            eMISmilitaryOccupationResponseType response = CallEmis(edipi);
            if (response.militaryOccupation != null)
            {
                return response.militaryOccupation.ToList();
            }
            return new List<MilitaryOccupation>();
        }
        public eMISmilitaryOccupationResponseType CallEmis(inputEdiPiOrIcn edipi, InputHeaderInfo headerInfo)
        {
            eMISmilitaryOccupationResponseType response = null;
            try
            {
                response = _client.getMilitaryOccupation(ref headerInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: MilitaryOccupationImporter.CallEmis: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return response;
        }

        public eMISmilitaryOccupationResponseType CallEmis(string edipi)
        {
            var inputEdipiIcn = InputEdipiOrIcnCreator.Create(edipi);
            return CallEmis(inputEdipiIcn, InputHeaderInfo);
        }
        public static List<MilitaryOccupation> GetMilitaryOccupationHistory(string edipi)
        {
            var importer = new MilitaryOccupationImporter();
            return importer.GetMilitaryOccupationData(edipi);
        }
    }
}
